# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
HashSet to help.

# Approach
<!-- Describe your approach to solving the problem. -->
- Maintained a HashSet to store the dictionary strings
- Created array minc[i], that will store minimum extra characters in s[0,i]
- Now by using two fingers method ( left index finger at beginning and right index finger at end of a substring ) 
- - Iterate over string 's'
- - if s [ j , i ) is in dictionary , then update if minc[j] is less than minc[i]
- - else it contains extra characters then minc[j] + length of string s(i,j) ; whichever minimum with minc[i]
- As minc[l] will store minimum extra characters in [0,l] : return it
---
Have a look at code for better understanding, if still have any confusion then please let me known at comments.
Keep solving...:)
# Complexity
- Time complexity : $$O(n^2)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(n)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int minExtraChar(String s, String[] dictionary) {
        int l = s.length();
        HashSet<String> ds = new HashSet<String>(Arrays.asList(dictionary));
        int[] minc = new int[l+1];             // minc[i] will store minimum extra characters in [0,i]
        Arrays.fill(minc, l);                  // initially assume that 'l' extra characters will be required ( worst case )
        minc[0] = 0;                           // as before first character no extra character

        for( int i = 1; i <= l; i++){
            for( int j = 0; j < i; j++){
                if( ds.contains( s.substring(j, i)) ){       // if s[j..i) is in dictionary , then update if minc[j] is less than minc[i]
                    minc[i] = Math.min(minc[i], minc[j]);
                }
                else{                                        // else it contains extra characters then minc[j] + length of string s(i,j) ; whichever minimum with minc[i]
                    minc[i] = Math.min( minc[i] , minc[j] + i - j);
                }
            }
        }
        return minc[l];    // as min[l] will store minimum extra characters in [0,l]
    }
}
```